﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.EwidencjaVat" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" CodePage="1200" autoeventwireup="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
<script runat="server">
	static bool wydrukTekstowy = true;
	static bool wydrukSzeroki = false;
	GridColumn colNip = new GridColumn();
	GridColumn colNazwa1 = new GridColumn();
	static string strona1Waski = "<SMALL><pre>" + new string(' ', 121) + "Strona: 1" + "</pre><BR/>";
	static string strona1Szeroki = "<SMALL><pre>" + new string(' ', 221) + "Strona: 1" + "</pre><BR/>";

	
  void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
    INaglowekVAT nag = (INaglowekVAT)args.Row;
    DokEwidencji ewid = nag.Ewidencja;
    if (param.Zaplacone)
    {
      Date data = Date.MaxValue;
      string dokumenty = "";
      foreach (Platnosc p in ewid.Platnosci)
      {
        if (!(p.DataRozliczenia < Date.MaxValue))
        {
          args.VisibleRow = false;
          return;
        }

        data = Date.Min(p.DataRozliczenia, data);
        dokumenty += p.RozliczoneDokumenty;
      }
      colZaplaty.EditValue = string.Format("{0} - {1}", data, dokumenty);
    }
  
    colNumer.EditValue              = nag.Numer;
    colNumerDokumentu.EditValue     = nag.NumerDokumentu;
    colDataDokumentu.EditValue      = nag.DataDokumentu;
    colDefinicja.EditValue          = nag.Definicja.Symbol;
  
    DaneKontrahenta danePodmiotu = ((PodmiotEwidencja)nag.Ewidencja).DaneKontrahenta;
  
    string kod = nag.Podmiot.Kod;
    if(danePodmiotu.EuVAT!="")
      kod += string.Format(" ({0})",danePodmiotu.EuVAT);
    colKod.EditValue      = kod;
    colNip.EditValue      = danePodmiotu.NIP;
		colNazwa1.EditValue = string.Format("{0}", danePodmiotu.Nazwa);			
		colNazwa.EditValue    = string.Format("{0} {1}",danePodmiotu.Nazwa,danePodmiotu.Adres);
  }
 
  void EwidencjaVAT_OnLoad(Object sender, EventArgs args){
    NagEwidencjiVATT.ParamsEx p     = null;
    if(DataContext1.Context.Contains(typeof(NagEwidencjiVATT.ParamsEx)))
                   p = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));
    if(p==null){
                   p = new NagEwidencjiVATT.ParamsEx(DataContext1.Context,true);
                   p.Typ = TypEwidencjiVAT.Sprzedaż;
                   if (DataContext1.Context.Contains(typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)))
                      p.Zakres = ((Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
                          DataContext1.Get(typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams))).Okres;
                   else
                      p.Zakres = ((OkresContext)DataContext1.Get(typeof(OkresContext))).Okres;
                   Grid1.DataSource = new SubTable(EwidencjaVatModule.GetInstance(DataContext1.Session).NagEwidencjiVATT.WgTyp[p.Typ],p.Zakres);
    }
    
    string tytul = "";
    if (p is NagRozliczenVATT.ParamsEx) {
        colData.Caption = "Data roz.";
        colData.DataMember = "Data";
        tytul = "Rejestr VAT";
    } else {
        colData.DataMember = "DataZaewidencjonowania";
        tytul = "Ewidencja VAT";
    }

		colNip.Caption = "NIP";
		colNip.Align = HorizontalAlign.Center;
		colNip.Width = 13;

		colNazwa1.Caption = "Podmiot";
		colNazwa1.EncodeHTML = true;
		colNazwa1.Align = HorizontalAlign.Left;
		
		if (wydrukTekstowy)
			colNumer.Width = 14;		
    
    if (wydrukSzeroki) {
			int staleNumery = 3;
			if (param.Pokaz3) staleNumery--;
			if (param.Pokaz5) staleNumery--;
			if (param.Pokaz7) staleNumery--;
			if (param.Pokaz22) staleNumery--;			
			if (staleNumery < 1) {
				colNumer.Width = 0;
				colNumerDokumentu.Width = 0;
			}
			else
				colNumerDokumentu.Width = 14;
			
        Grid1.WidthChars = 230;
        Grid1.Columns.Clear();
        Grid1.RowsInRow = 2;
        Grid1.Columns.Add(colLp);
        colLp.RowSpan = 2;
        Grid1.Columns.Add(colNumerDokumentu);
				colNumerDokumentu.Align = HorizontalAlign.Left;
        Grid1.Columns.Add(colZaplaty);
        colZaplaty.ColSpan = 21;        
        Grid1.Columns.Add(colDataDokumentu);
        Grid1.Columns.Add(colData);
        Grid1.Columns.Add(colNumer);        
				Grid1.Columns.Add(colNazwa1);
				Grid1.Columns.Add(colNip);			
        Grid1.Columns.Add(colNetto3);
        Grid1.Columns.Add(colVAT3);
        Grid1.Columns.Add(colNetto5);
        Grid1.Columns.Add(colVAT5);
        Grid1.Columns.Add(colNetto7);
        Grid1.Columns.Add(colVAT7);        
        Grid1.Columns.Add(colNetto8);
        Grid1.Columns.Add(colVAT8);
        Grid1.Columns.Add(colNetto22);
        Grid1.Columns.Add(colVAT22);
        Grid1.Columns.Add(colNetto23);
        Grid1.Columns.Add(colVAT23);
        Grid1.Columns.Add(colNettoZw);
        Grid1.Columns.Add(colNetto0);
        Grid1.Columns.Add(colNettoNP);
        Grid1.Columns.Add(colNetto);
        Grid1.Columns.Add(colVAT);
        Grid1.Columns.Add(colBrutto);
    }            


    if (!param.Pokaz3) {
      Grid1.Columns.Remove(colNetto3);
      Grid1.Columns.Remove(colVAT3);
      colNazwa.ColSpan--;
      colZaplaty.ColSpan--;
      if(wydrukTekstowy && !wydrukSzeroki)
        colNumer.Width += 10;
    }

    if (!param.Pokaz5) {
        Grid1.Columns.Remove(colNetto5);
        Grid1.Columns.Remove(colVAT5);
        colNazwa.ColSpan--;
        colZaplaty.ColSpan--;
        if (wydrukTekstowy && !wydrukSzeroki)
					colNumer.Width += 10;
    }

    if (!param.Pokaz7) {
        Grid1.Columns.Remove(colNetto7);
        Grid1.Columns.Remove(colVAT7);
        colNazwa.ColSpan--;
        colZaplaty.ColSpan--;
        if (wydrukTekstowy && !wydrukSzeroki)
            colNumer.Width += 10;
    }      

    if (!param.Pokaz22) {
        Grid1.Columns.Remove(colNetto22);
        Grid1.Columns.Remove(colVAT22);
        colNazwa.ColSpan--;
        colZaplaty.ColSpan--;
				if (wydrukTekstowy && !wydrukSzeroki)
					colNumer.Width += 10;
    }

    if (!param.Zaplacone)
    {
      Grid1.Columns.Remove(colZaplaty);
      colLp.RowSpan--;
      Grid1.RowsInRow--;
    }

    string tytulNaglowka =
      string.Format("{0} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5} | Odliczenia: {6}, Rodzaj: {7}, Rodzaj pod.: {8}, Status pod.: {9}",
			tytul, p.Typ, p.Zakres, p.Definicja == null ? "Wszystkie" : p.Definicja.ToString(),
			p.Podmiot == null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty, p.Odliczenia, p.RodzajZakupu, p.RodzajPodmiotu, p.StatusPodmiotu);          
  
    if(p.Porownanie!=TypPorownania.Brak)
      tytulNaglowka =
        string.Format("{0} | Kwota brutto {1} {2:n}",
          tytulNaglowka,CaptionAttribute.EnumToString(p.Porownanie),p.Kwota);

		if (wydrukTekstowy) {
			writePieczatka(param);
			writeTytulNaglowka(tytulNaglowka);
			DataContext1.NextPagesHeader = getNextPageHeader(param, tytulNaglowka);
			writeCopyright();
		} else {
			//ReportHeader1.Title = tytulNaglowka;
		}
  }
	
	void writePieczatka(ISessionable session) {
		CoreModule cm = CoreModule.GetInstance(session);
		DataLabelNazwaWieleLinii.EditValue = cm.Config.Firma.Pieczątka.NazwaSkrócona;
		DataLabelLinia1.EditValue = cm.Config.Firma.AdresSiedziby.Linia1;
		DataLabelLinia2.EditValue = cm.Config.Firma.AdresSiedziby.Linia2;
		DataLabelNIP.EditValue = cm.Config.Firma.Pieczątka.NIP;        		
	}

	void writeTytulNaglowka(string tytulNaglowka) {
		string[] titles = tytulNaglowka.Split('|');
		string margin = "                    ";
		DataLabelTytul1.EditValue = margin + titles[0].Trim();
		tytulNaglowka = "";
		for (int i = 1; i < titles.Length; i++) {
			tytulNaglowka += margin + titles[i].Trim() + "\n";
		}
		DataLabelTytul2.EditValue = tytulNaglowka;		
	}

	string getNextPageHeader(ISessionable session, string tytulNaglowka) {
		string[] titles = tytulNaglowka.Split('|');		
		return CoreModule.GetInstance(session).Config.Firma.Pieczątka.NazwaSkrócona.Trim() 
			+ " - " + titles[0] + " - " + titles[1] + "~Strona: {0}";
	}

	void writeCopyright() {
		string cr = "Koniec wydruku";
		int len = wydrukSzeroki ? 230 : 130;
		cr = cr + new string('=', len - cr.Length - DataContext1.Copyright.Length) + DataContext1.Copyright;
		Copyright.EditValue = cr;
	}
	
	Params param = null;
  [Context]
  public Params Param
  {
      set { param = value; }
  }

  public class Params : ContextBase
  {
    public Params(Context cx)
        : base(cx)
    {
    }
    
    bool zaplacone = false;
    [Caption("Tylko zapłacone")]
    [Soneta.Tools.Priority(1)]
    public bool Zaplacone
    {
        get { return zaplacone; }
        set { zaplacone = value; }
    }

    bool pokaz3 = false;
    [Caption("Pokaż 3%")]
    [Soneta.Tools.Priority(2)]
    public bool Pokaz3 {
        get { return pokaz3; }
        set { pokaz3 = value; }
    }

    bool pokaz5 = false;
    [Caption("Pokaż 5%")]
    [Soneta.Tools.Priority(3)]
    public bool Pokaz5 {
        get { return pokaz5; }
        set { pokaz5 = value; }
    }

    bool pokaz7 = false;
    [Caption("Pokaż 7%")]
    [Soneta.Tools.Priority(4)]
    public bool Pokaz7 {
        get { return pokaz7; }
        set { pokaz7 = value; }
    }      

    bool pokaz22 = false;
    [Caption("Pokaż 22%")]
    [Soneta.Tools.Priority(5)]
    public bool Pokaz22 {
        get { return pokaz22; }
        set { pokaz22 = value; }
    }                        
  }
</script>
		<meta http-equiv="Content-Type" content="text/html;charset=unicode">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR" >
		<meta content="C#" name="CODE_LANGUAGE" >
		<meta content="JavaScript" name="vs_defaultClientScript" >
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" >
  </HEAD>
	<body>
		<font face="Courier New">
		<form id="EwidencjaVAT" method="post" runat="server">
			<ea:DataContext id="DataContext1" OnContextLoad="EwidencjaVAT_OnLoad" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"></ea:DataContext>
				<ea:Section id="Naglowek" runat="server" Width="100%">&#27;&#80;
          <small><ea:datalabel id="DataLabelNazwaWieleLinii" runat="server" EncodeHTML="True"></ea:datalabel><BR>
          <ea:datalabel id="DataLabelLinia1" runat="server" EncodeHTML="True"></ea:datalabel><BR>
          <ea:datalabel id="DataLabelLinia2" runat="server" EncodeHTML="True"></ea:datalabel><BR>
          NIP:<ea:datalabel id="DataLabelNIP" runat="server" EncodeHTML="True"></ea:datalabel><BR></small>
          <ea:datalabel id="DataLabelTytul1" runat="server" EncodeHTML="True"></ea:datalabel><BR>
          <small><ea:datalabel id="DataLabelTytul2" runat="server" EncodeHTML="True"></ea:datalabel></small>
				</ea:Section>
			<% if (wydrukSzeroki) { %>	
			<SMALL><pre>                                                                                                                                                                                                                             Strona: 1</pre><BR>
            <%} else { %>				
            <SMALL><pre>                                                                                                                         Strona: 1</pre><BR>            
            <%}%>				            
			<ea:TextGrid id="Grid1" runat="server" ShowAgrSum="True" ShowPageSum="True" ShowPrevAgrSum="InFooter"
				OnBeforeRow="Grid1_BeforeRow" RowsInRow="4">
<Columns>
<ea:GridColumn runat="server" Width="5" DataMember="#" Caption="Lp" ID="colLp" RowSpan="4"></ea:GridColumn>
<ea:GridColumn runat="server" Caption="Nr ewid." ID="colNumer" EncodeHTML="true"></ea:GridColumn>
<ea:GridColumn runat="server" Align="Right" Caption="Nr dok." ID="colNumerDokumentu" EncodeHTML="True"></ea:GridColumn>
<ea:GridColumn runat="server" ColSpan="10" Caption="Podmiot (Nazwa + Adres)" ID="colNazwa" EncodeHTML="True"></ea:GridColumn>
<ea:GridColumn runat="server" ColSpan="12" Caption="Zapłaty" ID="colZaplaty" EncodeHTML="True"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data zaew." ID="colData"></ea:GridColumn>
<ea:GridColumn runat="server" ColSpan="3" Align="Center" Caption="Podmiot (Kod + NIP)" ID="colKod" EncodeHTML="True"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data dok." ID="colDataDokumentu"></ea:GridColumn>
<ea:GridColumn runat="server" Width="8" Align="Center" Caption="Def." ID="colDefinicja" EncodeHTML="True"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 3%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.3%.Netto.Value" ID="colNetto3"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 3%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.3%.VAT.Value" ID="colVAT3"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 5%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.5%.Netto.Value" ID="colNetto5"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 5%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.5%.VAT.Value" ID="colVAT5"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 7%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.7%.Netto.Value" ID="colNetto7"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 7%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.7%.VAT.Value" ID="colVAT7"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 8%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.8%.Netto.Value" ID="colNetto8"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 8%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.8%.VAT.Value" ID="colVAT8"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 22%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.22%.Netto.Value" ID="colNetto22"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 22%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.22%.VAT.Value" ID="colVAT22"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto 23%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.23%.Netto.Value" ID="colNetto23"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT 23%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.23%.VAT.Value" ID="colVAT23"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Wart. zw." Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.ZW.Netto.Value" ID="colNettoZw"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Wart. 0%" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.0%.Netto.Value" ID="colNetto0"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Wart. NP" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.SumaWgStawek.NP.Netto.Value" ID="colNettoNP"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Netto" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.Suma.Netto.Value" ID="colNetto"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="VAT" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.Suma.VAT.Value" ID="colVAT"></ea:GridColumn>
<ea:GridColumn runat="server" Width="10" Align="Right" Total="Sum" Caption="Brutto" Format="{0:n}" DataMember="Workers.PodsumowanieVATEx.Suma.Brutto.Value" ID="colBrutto"></ea:GridColumn>
</Columns>
			</ea:TextGrid>
			<BR/><pre><ea:DataLabel id="Copyright" runat="server" EncodeHTML="True"></ea:DataLabel></pre>
			</SMALL>&#12;
		</form>
		</font>
	</body>
</HTML>

